﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.VR.WSA;

public class MenuManager : MonoBehaviour
{

    PersistenceManager pm;
    public GameObject menu;

    [SerializeField]
    private bool loadImagesOnStart = false;

    // Use this for initialization
    void Start()
    {
        pm = GetComponent<PersistenceManager>();

        // if loadImagesOnStart is checked, then load polaroids on application start
        if (loadImagesOnStart)
        {
            if (pm != null)
            {
                pm.Load();
            }
        }

    }

    // Add a world anchor component to prevent wrong position of the menu
    // if the application gets focused again
    private void OnApplicationPause(bool pause)
    {
        if (menu.GetComponent<WorldAnchor>() == null)
        {
            menu.AddComponent<WorldAnchor>();
        }
    }

    // We don't need the menu's world anchor component anymore if
    // the application is being closed
    private void OnApplicationQuit()
    {
        if (menu.GetComponent<WorldAnchor>() != null)
        {
            DestroyImmediate(menu.GetComponent<WorldAnchor>());
        }
    }

    private void OnApplicationFocus(bool focus)
    {
        if (menu.GetComponent<WorldAnchor>() == null)
        {
            menu.AddComponent<WorldAnchor>();
        }
    }
}
